package easik.ui.menu;

import java.awt.event.ActionEvent;

import javax.swing.AbstractAction;

import easik.Easik;
import easik.sketch.constraint.Constraint;


/**
 *	Menu action for opening and loading a sketch
 *  
 * @author Kevin Green 2006
 * @since 2006-07-13 Kevin Green
 * @version 2006-07-26 Kevin Green
 */
public class HideAllConstraintsAction extends AbstractAction {	
	/**
	 * Create the menu option for loading a sketch	 
	 */
	public HideAllConstraintsAction() {
		super("Hide all constraints");		
		putValue( AbstractAction.SHORT_DESCRIPTION,  "Hide constraints graphically");		
	}
	
	/**
	 * Sets all constraints to invisible
	 * 
	 * @param e The action event
	 */
	public void actionPerformed(ActionEvent e ) {
		Constraint.setAllConstraintsVisible(Easik.getInstance().getFrame().getSketch().getConstraints(), false);
	}
}
